/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.MessageOutputType;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import fi.dy.masa.tweakeroo.tweaks.RenderTweaks;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.EntityRestriction;
import fi.dy.masa.tweakeroo.util.IMinecraftClientInvoker;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import fi.dy.masa.tweakeroo.util.PotionRestriction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3229;
import net.minecraft.class_3675;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MiscTweaks {
    public static final EntityRestriction ENTITY_TYPE_ATTACK_RESTRICTION = new EntityRestriction();
    public static final PotionRestriction POTION_RESTRICTION = new PotionRestriction();
    private static final KeybindState KEY_STATE_ATTACK = new KeybindState(class_310.method_1551().field_1690.field_1886, mc -> ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoAttack());
    private static final KeybindState KEY_STATE_USE = new KeybindState(class_310.method_1551().field_1690.field_1904, mc -> ((IMinecraftClientInvoker)mc).tweakeroo_invokeDoItemUse());
    private static int potionWarningTimer;

    public static void onTick(class_310 mc) {
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        MiscTweaks.doPeriodicClicks(mc);
        MiscTweaks.doPotionWarnings((class_1657)player);
        if (FeatureToggle.TWEAK_REPAIR_MODE.getBooleanValue()) {
            InventoryUtils.repairModeSwapItems((class_1657)player);
        }
        CameraEntity.movementTick();
    }

    public static void onGameLoop(class_310 mc) {
        PlacementTweaks.onTick(mc);
        RenderTweaks.onTick();
        Tweakeroo.renderCountItems = 0;
        Tweakeroo.renderCountXPOrbs = 0;
    }

    private static void doPeriodicClicks(class_310 mc) {
        if (GuiUtils.getCurrentScreen() == null) {
            MiscTweaks.handlePeriodicClicks(KEY_STATE_ATTACK, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_HOLD_ATTACK, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_ATTACK, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_ATTACK_INTERVAL, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_ATTACK_DURATION, (IConfigInteger)Configs.Generic.PERIODIC_ATTACK_INTERVAL, mc);
            MiscTweaks.handlePeriodicClicks(KEY_STATE_USE, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_HOLD_USE, (IConfigBoolean)FeatureToggle.TWEAK_PERIODIC_USE, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_USE_INTERVAL, (IConfigInteger)Configs.Generic.PERIODIC_HOLD_USE_DURATION, (IConfigInteger)Configs.Generic.PERIODIC_USE_INTERVAL, mc);
        } else {
            KEY_STATE_ATTACK.reset();
            KEY_STATE_USE.reset();
        }
    }

    private static void handlePeriodicClicks(KeybindState keyState, IConfigBoolean cfgPeriodicHold, IConfigBoolean cfgPeriodicClick, IConfigInteger cfgHoldClickInterval, IConfigInteger cfgHoldDuration, IConfigInteger cfgClickInterval, class_310 mc) {
        if (cfgPeriodicHold.getBooleanValue()) {
            int interval = cfgHoldClickInterval.getIntegerValue();
            int holdDuration = cfgHoldDuration.getIntegerValue();
            keyState.handlePeriodicHold(interval, holdDuration, mc);
        } else if (cfgPeriodicClick.getBooleanValue()) {
            int interval = cfgClickInterval.getIntegerValue();
            keyState.handlePeriodicClick(interval, mc);
        } else {
            keyState.reset();
        }
    }

    private static void doPotionWarnings(class_1657 player) {
        if (FeatureToggle.TWEAK_POTION_WARNING.getBooleanValue() && ++potionWarningTimer >= 100) {
            potionWarningTimer = 0;
            Collection effects = player.method_6026();
            if (!effects.isEmpty()) {
                int minDuration = -1;
                int count = 0;
                for (class_1293 effectInstance : effects) {
                    if (!MiscTweaks.potionWarningShouldInclude(effectInstance)) continue;
                    ++count;
                    if (effectInstance.method_5584() >= minDuration && minDuration >= 0) continue;
                    minDuration = effectInstance.method_5584();
                }
                if (count > 0) {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.potion_effects_running_out", (Object[])new Object[]{count, minDuration / 20});
                }
            }
        }
    }

    public static boolean isEntityAllowedByAttackingRestriction(class_1299<?> type) {
        if (!ENTITY_TYPE_ATTACK_RESTRICTION.isAllowed(type)) {
            MessageOutputType messageOutputType = (MessageOutputType)Configs.Generic.ENTITY_TYPE_ATTACK_RESTRICTION_WARN.getOptionListValue();
            if (messageOutputType == MessageOutputType.MESSAGE) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"tweakeroo.message.warning.entity_type_attack_restriction", (Object[])new Object[0]);
            } else if (messageOutputType == MessageOutputType.ACTIONBAR) {
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.warning.entity_type_attack_restriction", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean potionWarningShouldInclude(class_1293 effect) {
        return !effect.method_5591() && (((class_1291)effect.method_5579().comp_349()).method_5573() || !Configs.Generic.POTION_WARNING_BENEFICIAL_ONLY.getBooleanValue()) && effect.method_5584() <= Configs.Generic.POTION_WARNING_THRESHOLD.getIntegerValue() && effect.method_5584() >= 0 && POTION_RESTRICTION.isAllowed((class_1291)effect.method_5579().comp_349());
    }

    @NotNull
    public static List<class_3229> parseBlockString(String blockString) {
        List<Object> list = new ArrayList<class_3229>();
        String[] strings = blockString.split(",");
        int count = strings.length;
        int thicknessSum = 0;
        for (int i = 0; i < count; ++i) {
            String str = strings[i];
            class_3229 layer = MiscTweaks.parseLayerString(str, thicknessSum);
            if (layer == null) {
                list = Collections.emptyList();
                break;
            }
            list.add(layer);
            thicknessSum += layer.method_14289();
        }
        return list;
    }

    @Nullable
    private static class_3229 parseLayerString(String string, int startY) {
        class_2248 block;
        int thickness;
        String[] strings = string.split("\\*", 2);
        if (strings.length == 2) {
            try {
                thickness = Math.max(Integer.parseInt(strings[0]), 0);
            }
            catch (NumberFormatException e) {
                Tweakeroo.LOGGER.error("Error while parsing flat world string => {}", (Object)e.getMessage());
                return null;
            }
        } else {
            thickness = 1;
        }
        int endY = Math.min(startY + thickness, 256);
        int finalThickness = endY - startY;
        try {
            block = MiscTweaks.getBlockFromName(strings[strings.length - 1]);
        }
        catch (Exception e) {
            Tweakeroo.LOGGER.error("Error while parsing flat world string => {}", (Object)e.getMessage());
            return null;
        }
        if (block == null) {
            Tweakeroo.LOGGER.error("Error while parsing flat world string => Unknown block, {}", (Object)strings[strings.length - 1]);
            return null;
        }
        return new class_3229(finalThickness, block);
    }

    @Nullable
    private static class_2248 getBlockFromName(String name) {
        try {
            Optional opt;
            class_2960 id = class_2960.method_12829((String)name);
            if (id != null && (opt = class_7923.field_41175.method_10223(id)).isPresent()) {
                return (class_2248)((class_6880.class_6883)opt.get()).comp_349();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class KeybindState {
        private final class_304 keybind;
        private final Consumer<class_310> clickFunc;
        private boolean state;
        private int durationCounter;
        private int intervalCounter;

        public KeybindState(class_304 keybind, Consumer<class_310> clickFunc) {
            this.keybind = keybind;
            this.clickFunc = clickFunc;
        }

        public void reset() {
            this.state = false;
            this.intervalCounter = 0;
            this.durationCounter = 0;
        }

        public void handlePeriodicHold(int interval, int holdDuration, class_310 mc) {
            if (this.state) {
                if (++this.durationCounter >= holdDuration) {
                    this.setKeyState(false, mc);
                    this.durationCounter = 0;
                }
            } else if (++this.intervalCounter >= interval) {
                this.setKeyState(true, mc);
                this.intervalCounter = 0;
                this.durationCounter = 0;
            }
        }

        public void handlePeriodicClick(int interval, class_310 mc) {
            if (++this.intervalCounter >= interval) {
                this.clickFunc.accept(mc);
                this.intervalCounter = 0;
                this.durationCounter = 0;
            }
        }

        private void setKeyState(boolean state, class_310 mc) {
            this.state = state;
            class_3675.class_306 key = class_3675.method_15981((String)this.keybind.method_1428());
            class_304.method_1416((class_3675.class_306)key, (boolean)state);
            if (state) {
                this.clickFunc.accept(mc);
                class_304.method_1420((class_3675.class_306)key);
            }
        }
    }
}

